' String constants for the Setup Map

Public Const SOUTLINE_TITLE_ADDFILES = " Add Files to a Component"

Public Const SOUTLINE_TEXT_ADDFILES  = "<br><p>You can add files to a component by dragging them from Windows Explorer and dropping them onto the file list, but there are a lot of considerations that go into adding files to components. First, you need to decide which files need to be included in each component.  The guidelines listed below should help you in designing your components and the files that will be associated with those components.</p><ul><li>All files are self-registering or not.<li>All files have the same destination folder.</ul><p>You should also be aware of <a href='#' onclick='javascript:GoIntoIDE (""viewBestPractices"")'>Setup Best Practices</a> <a href='#' onclick='javascript:GoIntoIDE (""viewBestPractices"")'><img src='intoide.gif' border='0'></a> when adding files to a component.</p><p>There are three ways to associate files with components in InstallShield. <ol><li>When you create a component by right-clicking in the Setup Design view or Components view, first select the component's Files item to view its file list. Then do one of the following to associate files with this component:<ul><li>Drag and drop files from Windows Explorer onto the file list.<li>Right-click in the file list and select Add. In the resulting dialog, browse to select as many files as you want to add from that folder. Finally, click Open.</ul><li>When you create a component in the Project wizard, you can add files in the wizard's Application Files panel with one of the following methods:<ul><li>Drag and drop files from Windows Explorer onto the file list.<li>Right-click in the file list and select Add or click the Add Files button. In the resulting dialog, browse to select as many files as you want to add from that folder. Finally, click Open.</ul><li>Although the Component wizard may offer you a selection of files already installed on your system, most of the time you will arrive at a panel that asks you to add files. Use one of the following methods:<ul><li>Drag and drop files from Windows Explorer onto the file list.<li>Right-click in the file list and select Add. In the resulting dialog, browse to select as many files as you want to add from that folder. Finally, click Open.</ul></ol>"

Public Const SOUTLINE_TITLE_FILEPROP = " Set a File's Properties"

Public Const SOUTLINE_TEXT_FILEPROP = "<br><p>Right-click on any file and select Properties to specify attributes that you want set for the file when it is installed on the target system. You can either specify new properties for each file or use the properties that the file currently has on the target system by checking the Use System Settings box.</p><p>You can set a number of properties for each file you're installing:</p><ul><li><span class='subtitle'>Language</span>  &nbsp;Enter the decimal value of the file's languages. The default language is English (1033). Separate multiple language IDs with a comma.<li><span class='subtitle'>Font Name</span>  &nbsp;If you're installing a font, you can specify the font name here in the format <i>FontName</i> (FontType)for example, <i>Roman</i> (All res). InstallShield provides the name of the font for you if it is registered on your system.<li><span class='subtitle'>Read-only</span>  &nbsp;Set this attribute if you want the file to be read-only when installed.<li><span class='subtitle'>Hidden</span>  &nbsp;Set this attribute if you want the file to be hidden when installed.<li><span class='subtitle'>Vital</span>  &nbsp;Set this attribute to indicate that this file is vital to the operation of its component. A component will not be installed if a vital file cannot be installed for any reason. The end user will see an error message with Retry and Cancel options if a vital file cannot be installed, instead of the usual Abort, Retry, and Ignore buttons.<li><span class='subtitle'>System</span>  &nbsp;Set this attribute if you want the file to be installed as a system file.</ul>"

Public Const SOUTLINE_TITLE_KEYFILE = " Specify a Key File"

Public Const SOUTLINE_TEXT_KEYFILE = "<br><p>A key file is a file that the Windows Installer uses to detect the component's presence. If a key file is in its proper location, then Windows Installer assumes that the entire component has been installed properly.  Also, if you would like to create shortcuts or advanced component settings, you must set a key file.</p><p>It is important to note that a component can only have one key file.  If you try to set a second key file or key path in a component you will receive a warning asking you if you would like to replace the existing key file.</p><p>To assign a key file you should right-click on a file in the files list and select Set Key File.  The file icon for this file will be replaced with the key file icon.</p>"

Public Const SOUTLINE_TITLE_SELFREG = " Mark a File as Self-Registering"

Public Const SOUTLINE_TEXT_SELFREG = "<br><p>InstallShield will register all of your self-registering files as long as they are in a component that has the Self-Register property set to Yes. The files are then unregistered when they are uninstalled.</p><p>Before setting the component's Self-Register property, make sure that all of the files in the component are self-registering. To mark the files as self-registering:</p><ul><li>In the Setup Design view or Components view, select the component in the tree view. Its property sheet opens to the right.<li>Click on the Self-Register property to display a drop-down list in the property sheet.<li>Select Yes from the drop-down list to set the component to self-registering.</ul><p>The preferred method for installing self-registering files is now to make the necessary registry entries with your setup. Instead of marking a file as self-registering, use the component's <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvancedSettings.htm"")'>advanced settings</a>  <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvancedSettings.htm"")'><img src='intohelp.gif' border='0' align='texttop'></a> to register the progIDs, type libraries, and so on, for the component's key file. Using the advanced settings works whether you are installing the file in the setup or advertising it for &ldquo;just-in-time installation.&rdquo;</p>"

Public Const SOUTLINE_TITLE_APPPATH = " Application Paths"

Public Const SOUTLINE_TEXT_APPPATH = "<br><p>An app paths key is considered one of the most important setup-related registry keys.  This key tells the operating system where the program and its DLLs are located if they are not in the system's path.  If an end user moves the program or one of the DLLs, this key will be automatically updated by Windows.</p><p>For more information on creating app paths keys, see <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAddAppPathsToComponent.htm"")'>Create an Application Paths Key</a> <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAddAppPathsToComponent.htm"")'><img src='intohelp.gif' border='0' align='texttop'></a>.</p>"

Public Const SOUTLINE_TITLE_COMREG = " COM Registration"

Public Const SOUTLINE_TEXT_COMREG = "<br><p><table align='right' cellpadding='0' cellspacing='0'><tr><td><img id='btnShowMe' src='showmebutton.gif' title='Click here to launch a demo to illustrate this feature.' style='cursor:hand' onmousedown=""btnShowMe.src='showmebuttondown.gif'"" onmouseup=""btnShowMe.src='showmebutton.gif'"" onclick='javascript:OpenDemo(""registercomserver"")'></td></tr></table></p><p>The COM Registration advanced setting is intended to replace self-registration, which is a violation of <a href='#' onclick='javascript:GoIntoIDE (""viewBestPractices"")'>Setup Best Practices</a> <a href='#' onclick='javascript:GoIntoIDE (""viewBestPractices"")'><img src='intoide.gif' border='0' align='texttop'></a>.  With COM Registration you can register the COM server that you have set as your component's <span class='definition' title='A key file is a file that the Windows Installer uses to detect the component&rsquo;s presence.'>key file</span>.</p><p>For more information on COM registration, see <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvCOMRegistration.htm"")'>COM Registration Advanced Setting</a> <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvCOMRegistration.htm"")'><img src='intohelp.gif' border='0' align='texttop'></a>."

Public Const SOUTLINE_TITLE_CONTROLNT = " Control NT Service"

Public Const SOUTLINE_TEXT_CONTROLNT = "<br><p><table align='right' cellpadding='0' cellspacing='0'><tr><td><img id='btnShowMe' src='showmebutton.gif' title='Click here to launch a demo to illustrate this feature.' style='cursor:hand' onmousedown=""btnShowMe.src='showmebuttondown.gif'"" onmouseup=""btnShowMe.src='showmebutton.gif'"" onclick='javascript:OpenDemo(""controlntservice"")'></td></tr></table></p><p>The ideal place to create and control <span class='definition' title='A service is an executable that gets special treatment from the operating system.'>NT services</span> is in the Component wizard.  However, if you need more flexibility and control over each service you can create a component, right in the IDE, that will control your NT service.</p><p>For more information on using the control NT service advanced setting, see <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvCtrlNTServ.htm"")'>Control NT Service Advanced Setting</a> <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvCtrlNTServ.htm"")'><img src='intohelp.gif' border='0' align='textop'></a>.</p>"

Public Const SOUTLINE_TITLE_FILETYPE = " Register File Types"

Public Const SOUTLINE_TEXT_FILETYPE = "<br><p><table align='right' cellpadding='0' cellspacing='0'><tr><td><img id='btnShowMe' src='showmebutton.gif' title='Click here to launch a demo to illustrate this feature.' style='cursor:hand' onmousedown=""btnShowMe.src='showmebuttondown.gif'"" onmouseup=""btnShowMe.src='showmebutton.gif'"" onclick='javascript:OpenDemo(""filetypes"")'></td></tr></table></p><p>If your application requires its own file types (for instance, Notepad uses a .txt file), you will need to register those file extensions.</p><p>For more information, please see <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvFileTypes.htm"")'>Register File Types</a> <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvFileTypes.htm"")'><img src='intohelp.gif' border='0' align='texttop'></a>.</p>"

Public Const SOUTLINE_TITLE_NTSERV = " Install NT Services"

Public Const SOUTLINE_TEXT_NTSERV = "<br><p><table align='right' cellpadding='0' cellspacing='0'><tr><td><img id='btnShowMe' src='showmebutton.gif' title='Click here to launch a demo to illustrate this feature.' style='cursor:hand' onmousedown=""btnShowMe.src='showmebuttondown.gif'"" onmouseup=""btnShowMe.src='showmebutton.gif'"" onclick='javascript:OpenDemo(""installntservices"")'></td></tr></table></p><p>With the <span class='definition' title='A service is an executable that gets special treatment from the operating system.'>NT Services</span> advanced setting you can specify registration information when installing your services.  See <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvNTServ.htm"")'>Install NT Services Advanced Settings</a> <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpAdvNTServ.htm"")'><img src='intohelp.gif' border='0' align='texttop'></a> for more information.</p>"

Public Const SOUTLINE_TITLE_PUBLISHCOMP = " Publishing"

Public Const SOUTLINE_TEXT_PUBLISHCOMP = "<br><p>To create publishing information for your components you should use the Publishing advanced setting. Publishing is a type of advertising (&ldquo;just-in-time&rdquo; installation) in which no user-interface elements are created for the component during installation, but the component can be installed through the Add/Remove Programs applet of the Control Panel or when an installed component requests the published component from the installer.</p><p>For more information on publishing components, see <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpPublishComponent.htm"")'>Specifying Publishing Information</a> <a href='#' onclick='javascript:OpenHelpToTopic (""IHelpPublishComponent.htm"")'><img src='intohelp.gif' border='0' align='texttop'></a>.</p>"

Public Const SOUTLINE_TITLE_ACTIONTYPE = " Action Type Panel"

Public Const SOUTLINE_TEXT_ACTIONTYPE = "<br><p>From this panel you can choose which type of action you would like to create.  Currently Custom Action is the only choice that is allowed.  In future versions the &ldquo;Dialog&rdquo; and &ldquo;Built-in action&rdquo; options will also be available.</p>"

Public Const SOUTLINE_TITLE_CUSTOMACTION = " Custom Action Panel"

Public Const SOUTLINE_TEXT_CUSTOMACTION = "<br><p>In the Custom Action panel you can enter the name of a new custom action or you can select an existing custom action from the list of available actions.</p>"

Public Const SOUTLINE_TITLE_CATYPE = " Custom Action Type Panel"

Public Const SOUTLINE_TEXT_CATYPE = "<br><p>You should enter a description of your custom action in this panel and choose the type of custom action that you would like to create.  The only choices currently available are EXE and DLL.</p>"

Public Const SOUTLINE_TITLE_CAPROP = " Custom Action Properties Panel"

Public Const SOUTLINE_TEXT_CAPROP = "<br><p>The Custom Action Properties panel prompts you for the location where your file will be during the setup.  You can choose from Temporary, Installed, or Local.  Temporary means that the file will be installed temporarily in the end user's temp directory.  Installed means that it will be installed during the current installation process.  Local means that the file will already be located on the end user's machine.</p><p>Next, set the Scheduling property for your custom action. Database Processing means that the Windows Installer will execute your custom action as it processes the .msi file. Script Processing tells the installer to queue the action and perform it in sequence with all of the other queued actions. And Rollback means that the action is executed if the installation is unsuccessful (&ldquo;rolls back&rdquo;).</p><p>The last setting on this dialog is the Wait option.  If you choose Synchronous your setup will not continue until the custom action has been completed.  Asynchronous means that your custom action will execute simultaneously with your setup.</p>"

Public Const SOUTLINE_TITLE_CALOC = " Custom Action Location Panel"

Public Const SOUTLINE_TEXT_CALOC = "<br><p>In the Custom Action Location panel you can associate the your file with the action. Click the Browse button to navigate to this file.</p><p>If your file is an EXE you can pass command line arguments to the file.  If it is a DLL you should specify its entry point.</p>"

Public Const SOUTLINE_TITLE_SEQUENCE = " Sequence Panel"

Public Const SOUTLINE_TEXT_SEQUENCE = "<br><p>The Sequence panel allows you to set the sequence type, conditions and set the location where you would like the action to execute.  First you should choose a sequence type from the list.  Then you should define any conditions that you would like to have.  Select one of the conditions from the list to view its definition.</p><p>Setting the location of your action is the most difficult part of creating a custom action.  To insert an action, right-click on the action that you would like your action to follow.  The drop-down list displays different action types.  Select the type of action that you would like to insert.  Your new action should appear below the action you just clicked on."
